//
//  GHInitializer.h
//  Garmin Health
//
//  Created by Echeandia, Augie on 10/4/16.
//  Copyright © 2016 Garmin International, Inc. or its affiliates. All rights reserved.
//

#import <Foundation/Foundation.h>

/**
 *  The GHInitializer class provides an interface to global objects that SDK client
 *  apps need to initialize.
 */
@interface GHInitializer : NSObject

/**
 *  Exposes the GHInitializer singleton class.
 */
+ (GHInitializer *)sharedManager;

/**
 *  Initialize the license for the SDK.
 *  @param key  Garmin provided license key.
 */
- (void)initializeLicense:(NSString *)key;

/**
 *  Optionally initialize Garmin Health API services.
 *  @param clientID  Garmin provided client ID.
 *  @param secret  Garmin provided secret.
 */
- (void)initializeClientID:(NSString *)clientID secret:(NSString *)secret;

/** NS_UNAVAILABLE */
+ (instancetype)new NS_UNAVAILABLE;

/** NS_UNAVAILABLE */
- (instancetype)init NS_UNAVAILABLE;


@end
